<?php
//include 'valida.php';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta charset="UTF-8">    
    <meta http-equiv="Cache-Control" content="no-store" />
    
    
    <title>Activar Cuenta</title>
    <script src="js/jquery_3.6.js"></script>
    <script src="js/sweetAlert.js"></script>
    <script>
            //PHP
    function alertError(mensaje) {

        Swal.fire({
            type: 'error',
            title: 'Error',
            text: mensaje,
            confirmButtonColor: 'red',
            confirmButtonText: 'ACEPTAR',
            //html: message,
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
              eval();
            }
        })
    }

    function alertOk(title, message, callback) {
        Swal.fire({
          title: title,
          html: message,
          type: 'success',
          reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed || result.value) {
                // Ejecutar la redirección si se confirma
                if (typeof callback === 'function') {
                    callback();
                }
            }
        });
    }

    //js o jquery
    function alertConfirm(title, message, callback) {
        Swal.fire({
            title: title,
            text: message,
            type: 'warning', 
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Continuar',
            cancelButtonText: 'Cancelar',
            reverseButtons: true
        }).then((result) => {

            if (result.isConfirmed || result.value) {
                // Ejecutar la redirección si se confirma
                if (typeof callback === 'function') {
                    callback();
                }
            }
        });
    }

    function alertForm(id, message) {
        Swal.fire({
          type: 'error',
          title: 'Datos incompletos',
          text: message,
          confirmButtonColor: 'red',
          confirmButtonText: 'ACEPTAR',
          reverseButtons: true
        }).then((result) => {
          if (result.value) {
            setTimeout("$('#" + id + "').focus()", 1000);
          }
        })
    }
    /**PARA LOGIN
     * 
    */

    $(document).ready(function() {
            //e.preventDefault(); // Prevenir el envío normal del formulario
            // Extraer el token de la URL
            const urlParams = new URLSearchParams(window.location.search);            
            const tokenDeEmail = urlParams.get('token');
            // Obtener el token almacenado en localStorage
            const tokenDeLocalStorage = localStorage.getItem('tokenVerificacion');
            var tlocal=tokenDeEmail;
            var turl=tokenDeLocalStorage
            if (tlocal==turl) {
                console.log("son iguales")
            }else{
                console.log("No son iguales");
            }
            console.log("Token desde la URL: ",tokenDeEmail);
            console.log("Token desde localStorage: " ,tokenDeLocalStorage);
            if (!tokenDeLocalStorage) {
                alertError("No se encontró un token de verificación almacenado. Por favor, regístrate nuevamente.");
                return;
            }
            // Comparar tokens
            if (tokenDeEmail === tokenDeLocalStorage) {
                // Tokens coinciden, enviamos solicitud al servidor para activar la cuenta
                //localStorage.setItem('verificado','1');               
                $.ajax({
                    url: 'stg.php',
                    type: 'POST',
                    dataType:'JSON',
                    data: {
                        type:5,//Enviar
                        token: tokenDeEmail
                    },
                    success: function(response) {
                        console.log("Respuesta del servidor: ", response); // Para depurar
                        const res = response;
                        if (res.flagerror === 0) {                            
                            activarCuenta(tokenDeEmail);

                            alertOk('Cuenta Verficada', 'Su cuenta ha sido activada exitosamente', function() {
                                // Una vez que el usuario hace clic en aceptar, redirige
                                window.location.href = "dashboard.php";
                            });
                            

                            /*    
                            alertConfirm('Éxito', "Cuenta activada exitosamente.", function() {                            
                                window.location.href = "/index.php";
                            });
                            */                            
                        } else {
                            alertOk("Error: " + res.Message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log("Estado: " + status);
                        console.log("Error: " + error);
                        console.log("Respuesta del servidor: " + xhr.responseText);
                        alertError("Hubo un error en la solicitud de activación.");
                    }
                });
            } else {
                alertError("El token de verificación no coincide. Por favor, revisa tu correo y vuelve a intentar.");
            }

        // Función para activar la cuenta y actualizar el campo 'verificado'
            function activarCuenta(token) {

                    var usuarios = JSON.parse(localStorage.getItem('usuarios')) || [];            
                    // Buscar el usuario que coincida con el token
                    const usuarioIndex = usuarios.findIndex(usuario => usuario.token === token);

                    if (usuarioIndex !== -1) {
                        // Actualizar el campo 'verificado' a 1
                        usuarios[usuarioIndex].verificado = 1;
                        // Guardar el arreglo actualizado en localStorage
                        localStorage.setItem('usuarios', JSON.stringify(usuarios));                
                        //alert("Cuenta activada exitosamente.");
                        console.log('Cuenta activada, valor de verificado actualizado a 1.');
                    } else {
                        alertError("No se encontró un usuario con ese token.");
                    }
            }
    });
    </script>
</head>
<body>
    <h1>Activando tu cuenta...</h1>
    
</body>
</html>
