
$(document).ready(function () {    
    //PHP
    function alertError(mensaje) {
        Swal.fire({
            type: 'error',
            title: 'Error',
            text: mensaje,
            confirmButtonColor: 'red',
            confirmButtonText: 'ACEPTAR',
            //html: message,
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
              eval();
            }
        })
    }

    function alertOk(title, message, action) {
        Swal.fire({
          title: title,
          html: message,
          type: 'success',
          reverseButtons: true
        }).then((result) => {
          if (result.value) {
            eval(action);
          }
        })
    }

    //js o jquery
    /*
    function alertConfirm(title, message, action) {
        Swal.fire({
          title: title,
          text: message,
          type: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Continuar',
          cancelButtonText: 'Cancelar',
          reverseButtons: true
        }).then((result) => {
          if (result.value) {
            eval(action); // Ejecutar la acción pasada como parámetro
          }
        });
    }
    */
    function alertConfirm(title, message, callback) {
        Swal.fire({
            title: title,
            text: message,
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Continuar',
            cancelButtonText: 'Cancelar',
            reverseButtons: true
        }).then((result) => {

            if (result.isConfirmed || result.value) {
                // Ejecutar la redirección si se confirma
                if (typeof callback === 'function') {
                    callback();
                }
            }            
        });
    }

    function alertForm(id, message) {
        Swal.fire({
          type: 'error',
          title: 'Datos incompletos',
          text: message,
          confirmButtonColor: 'red',
          confirmButtonText: 'ACEPTAR',
          reverseButtons: true
        }).then((result) => {
          if (result.value) {
            setTimeout("$('#" + id + "').focus()", 1000);
          }
        })
    }
    /**PARA LOGIN
     * 
    */

    $("#form-login").submit(function (e) {
        e.preventDefault(); // Prevenir el envío normal del formulario
        var username = $("#username").val().trim(); 
        var password = $("#password").val().trim(); 
        var error = 0; // Inicializar la variable de error

        var existingUsers = JSON.parse(localStorage.getItem('usuarios')) || [];

        var usuarios = JSON.parse(localStorage.getItem('usuarios')) || [];            
        // Buscar el usuario que coincida con el token
        const usuarioIndex = usuarios.findIndex(usuario => usuario.verificado === 0);
        
        // Validar el nombre de usuario
        if (username === "") {
            alertForm('username','Ingrese su usuario.');
            error = 1; // Establecer error a 1
        }
        // Validar la contraseña
        if (password === "") {
            alertForm('password','Ingrese una contraseña.');
            error = 1; // Establecer error a 1
        }
        if(username === "" && password === ""){
            alertForm('password','Ingrese tu usuario y contraseña.');
            error = 1;
        }
        
        if(usuarioIndex === 0){
            alertError('Cuenta por confirmar,  por favor revisa tu buzon de email para activar tu cuenta');
            error = 1;
        }
        console.log(usuarioIndex);

        // Si no hay errores, proceder con la solicitud AJAX
        if (error === 0) {
            // Desactivar el botón de envío
            $("button[type='submit']").prop("disabled", true);
            $("#loader").show(); //Mostrar el loader
            var encriptarPassword = CryptoJS.MD5(CryptoJS.SHA1(password).toString()).toString();
            
            $.ajax({
                    url: 'stg.php',
                    type: 'POST',
                    dataType:'JSON',
                    data: {
                        type: 1, // Enviar el tipo de acción para login
                        username: username,
                        password: encriptarPassword,
                        localStorageUsers: existingUsers, // Usuarios desde localStorage
                        estatus:usuarioIndex
                    },
                    success: function (response) {
                        var jsonResponse = response; // Asegúrate de parsear la respuesta JSON
                        //console.log('Respuesta del servidor:', response);
                        if (response.flagerror === 0) { // Verifica si no hay error
                            window.location.href = "dashboard.php"; // Redirigir a dashboard
                        } else {
                            alertForm('username',jsonResponse.Message);
                        }
                    },
                    error: function (xhr, status, error) {
                        console.log("Estado: " + status);
                        console.log("Error: " + error);
                        console.log(xhr.responseText); // Muestra la respuesta del servidor en caso de error
                        alertError('Ocurrió un error en la solicitud.');
                    },
                    complete: function () {
                        // Reactivar el botón de envío y ocultar el loader
                        $("button[type='submit']").prop("disabled", false);
                        $("#loader").hide(); // Ocultar el loader
                    }
            });        
        } else {
            // Reactivar el botón si hay errores
            $("button[type='submit']").prop("disabled", false);
            $("#loader").hide(); // Ocultar el loader si hay errores
        }
    });


    
    validarEmailFormato();
    validarTel();
    validarTelConfirm();
    validarEmail('email', 'email_confir');
    //VALIDAICONES
    // Ocultar los mensajes de error al inicio    
    $('#error-tel, #error-email, #error-pwd').hide();
    
    $('#tel_confir').on('input', function () {
        let tel = $('#tel').val();
        let tel_confir = $('#tel_confir').val();
        if (tel_confir.length > 0 && tel !== tel_confir) {
            $('#error-tel').show();
        } else {
            $('#error-tel').hide();
        }
    });
    $('#email_confir').on('input', function () {
        let email = $('#email').val();
        let email_confir = $('#email_confir').val();

        if (email_confir.length > 0 && email !== email_confir) {
            $('#error-email').show();
        } else {
            $('#error-email').hide();
        }
    });
    $('#pwd_confir').on('input', function () {
        let pwd = $('#pwd').val();
        let pwd_confir = $('#pwd_confir').val();

        if (pwd_confir.length > 0 && pwd !== pwd_confir) {
            $('#error-pwd').show();
        } else {
            $('#error-pwd').hide();
        }
    });

    $('#registerForm').on('submit', function (event) {       
        event.preventDefault(); // Prevenir el envío normal del formulario
        var error = 0;
        var email = $('#email').val().trim();
        var email_confir = $('#email_confir').val().trim();
        var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        
        // Obtener valores de los campos
        var nombre = $('#nombre').val().trim();
        var apellidos = $('#apellidos').val().trim();
        var tel = $('#tel').val().trim().replace(/\D/g, '');
        var tel_confir = $('#tel_confir').val().trim().replace(/\D/g, '');        
        var pwd = $('#pwd').val().trim();
        var pwd_confir = $('#pwd_confir').val().trim();        

        if (nombre === "") {
            alertForm('nombre', 'Ingrese su nombre.');
            error = 1;
            return;
        }
        if (apellidos === "") {
            alertForm('apellidos', 'Ingrese sus apellidos.');
            error = 1;
            return;
        }
        if (tel === "") {
            alertForm('tel', 'Ingrese su teléfono.');
            return;
        }else if(tel.length !== 10){
            alertForm('tel', 'El número de teléfono debe tener 10 dígitos.');
            return;
        }
        if (tel_confir === "") {
            alertForm('tel_confir', 'Confirme su teléfono.');
            return;
        }else if(tel_confir.length !== 10){
            alertForm('tel_confir', 'El número de teléfono de confirmación debe tener 10 dígitos.')
            return;
        }
        if (tel !== tel_confir) {
            alertForm('tel_confir', 'El teléfono de confirmación no coincide  primer número capturado');
            $('#error-tel').show();            
            return;
        }

        if (email === "") {
            alertForm('email', 'Ingrese su correo electrónico.');
            return;
        }else if(!emailRegex.test(email)){
            alertForm('email', 'El formato del correo electrónico no es válido.');
            return;
        }

        if (email_confir === "") {
            alertForm('email_confir', 'Confirme su correo electrónico.');
            return;
        }else if(!emailRegex.test(email_confir)){
            alertForm('email_confir', 'El formato del correo electrónico de confirmación no es válido.');
            return;
        }
        if (email !== email_confir) {
            alertForm('email_confir', 'El correo de confirmación no coincide con el primer correo capturado.');
            $('#error-email').show();            
            return;
        }
        if (pwd === "") {
            alertForm('pwd', 'Ingrese su contraseña.');            
            return;
        }

        if (pwd_confir === "") {
            alertForm('pwd_confir', 'Confirme su contraseña :).');
            return;            
        }
        // Validar coincidencias para confirmación
        if (pwd !== pwd_confir) {
            alertForm('pwd_confir', 'Las contraseñas no coinciden.');
            $('#error-pwd').show();            
            return;
        }
        // Si todo es válido, proceder con AJAX
        if (error === 0) {
            // Desactivar el botón de envío
            $("button[type='submit']").prop("disabled", true);
            $("#loader").show(); // Mostrar el loader
            //datos para enviar si no hay error
            var dataToSend = {
                type: 3,
                nombre: nombre,
                apellidos: apellidos,
                tel: tel,
                tel_confir: tel_confir,
                email: email,
                email_confir: email_confir,
                pwd: pwd,
                pwd_confir: pwd_confir
            };
            
            
            $.ajax({
                url: 'stg.php',
                type: 'POST',
                dataType: 'JSON',
                data: dataToSend,
                cache: false, //Desactiva la caché solo para esta petición
                success: function (response) {                    
                    var jsonResponse = response;
                    if (jsonResponse.flagerror === 0) {
                        if (guardarUsuario(nombre,apellidos,tel,email,pwd)) {                            
                            alertConfirm('Registro Exitoso',
                                        'Por favor verifica tu cuenta. Revisa tu correo', function() {                                
                                        window.location.href = "index.php";
                            });
                        }                        
                    } else {
                        alertError(response.Message);
                    }
                },
                error: function (xhr, status, error) {
                    console.log("Estado: " + status);
                    console.log("Error: " + error);
                    console.log(xhr.responseText); // Muestra la respuesta del servidor en caso de error
                    alertError('Ocurrió un error en la solicitud.');
                },
                complete: function () {
                    // Reactivar el botón de envío y ocultar el loader
                    $("button[type='submit']").prop("disabled", false);
                    $("#loader").hide(); // Ocultar el loader
                }
            });
        }

        function guardarUsuario(nombre,apellidos,tel,email,pwd){            
            var usuarios = JSON.parse(localStorage.getItem('usuarios')) || [];
            // para obtener los usuarios registrados
            const usuarioExistente = usuarios.find(user=>user.email === email);
            //para ver usuarios registrado
            if (usuarioExistente) {
                alertError('Ya existe un usuario con  este correo');
                return false;
            } 
            //Generación del token y almacenamiento en localStorage
            var tokenVerificacion = CryptoJS.MD5(CryptoJS.SHA1(pwd).toString()).toString()+ CryptoJS.MD5(email).toString();
           
            localStorage.setItem('tokenVerificacion', tokenVerificacion);
            //Encriptar
            var hashPwd = CryptoJS.MD5(CryptoJS.SHA1(pwd).toString()).toString();
            
            const nuevoUsuario={
                nombre,
                apellidos,
                tel,
                email,
                pwd:hashPwd,
                token:tokenVerificacion,
                verificado:0,//Por default 0 no verificado aun
            };
            // agregar el nuevo usuario al arreglo
            usuarios.push(nuevoUsuario);
            localStorage.setItem('usuarios',JSON.stringify(usuarios));
            //enviarCorreoConfirmacion(email,tokenVerificacion);
            //4 Para enviar correo
            $.ajax({
                url: 'stg.php',
                type: 'POST',
                dataType: 'JSON',
                data:{
                    type:4,
                    nombre:nombre,
                    email:email,
                    token:tokenVerificacion  //Envio de token
                },
                success:function(response){                        
                    
                    if (response.flagerror === 0) {
                        /*
                        alertConfirm('Registro Exitoso 2', 'Por favor verifica tu cuenta. Revisa tu correo', function() {
                            window.location.href = "dashboard.php";
                        });
                        */
                    } else {
                        alertError(response.Message);
                    }
                    
                },
                error:function(xhr,status,error){
                    console.log("Estado: " + status);
                    console.log("Error: " + error);
                    console.log("Respuesta del servidor: " + xhr.responseText); // Depurar respuesta
                    alertError('Error al enviar el correo de verificación.');
                }
            });
            return true;
        }    
    });

});//FIN $(document).ready(function()


//Funciones
function validarTel(){
    $('#tel').on('input', function() {
        // Eliminar todo lo que no sea un número
        let input = $(this).val().replace(/\D/g, '');

        // Limitar a 10 dígitos
        if (input.length > 10) {                        
            input = input.substring(0, 10);
        }
        // Formatear el número
        let formattedInput = '';

        if (input.length > 0) {
            formattedInput += input.substring(0, 2); // Primeros 2 dígitos
        }
        if (input.length > 2) {
            formattedInput += '-' + input.substring(2, 6); // Siguiente 4 dígitos
        }
        if (input.length > 6) {
            formattedInput += '-' + input.substring(6); // Últimos 4 dígitos
        }
        // Actualizar el campo de entrada con el valor formateado
        $(this).val(formattedInput);
    });

}

function validarTelConfirm(){

    $('#tel_confir').on('input', function() {
        // Eliminar todo lo que no sea un número
        let input = $(this).val().replace(/\D/g, '');
        // Limitar a 10 dígitos
        if (input.length > 10) {                        
            input = input.substring(0, 10);
        }
        // Formatear el número
        let formattedInput = '';
        if (input.length > 0) {
            formattedInput += input.substring(0, 2); // Primeros 2 dígitos
        }
        if (input.length > 2) {
            formattedInput += '-' + input.substring(2, 6); // Siguiente 4 dígitos
        }
        if (input.length > 6) {
            formattedInput += '-' + input.substring(6); // Últimos 4 dígitos
        }
        // Actualizar el campo de entrada con el valor formateado
        $(this).val(formattedInput);
    });
}

//Validar email
function validarEmail(inputId, confirmId) {
    // Validar el formato del correo electrónico al escribir en el campo de email
    $('#' + inputId).on('input', function() {
        let email = $(this).val();

        // Validar el formato del email
        if (!validarEmailFormato(email)) {
            $('#error-' + inputId).text("Formato de correo inválido").show(); // Mostrar error de formato
        } else {
            $('#error-' + inputId).hide(); // Ocultar error si el formato es correcto
            validarConfirmacionEmail(inputId, confirmId); // Verificar confirmación
        }
    });

    // Validar el campo de confirmación también
    $('#' + confirmId).on('input', function() {
        validarConfirmacionEmail(inputId, confirmId);
    });
}

function validarConfirmacionEmail(inputId, confirmId) {
    let email = $('#' + inputId).val();
    let confirmEmail = $('#' + confirmId).val();

    // Mostrar mensaje de error si no coinciden
    if (confirmEmail.length > 0 && email !== confirmEmail) {
        $('#error-' + confirmId).text("Los correos no coinciden").show();
    } else {
        $('#error-' + confirmId).hide();
    }
}

function validarEmailFormato(email) {
    // Expresión regular regex para validar el formato del correo electrónico sapo@com.mx
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return emailRegex.test(email);
}