<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Cache-Control" content="no-store" />
    <meta http-equiv="Pragma" content="no-cache" />
    <meta http-equiv="Expires" content="0" />
    <title>Document</title>
    
    <script src="js/jquery_3.6.js"></script>
    <script src="js/sweetAlert.js"></script>
    <script src="js/crypto_js.js"></script>
    <link rel="stylesheet" href="css/styles.css">

</head>
<body>
    <!--Registro -->
    <?php 

    session_start(); // Inicia la sesión al principio del archivo

    // Validar y procesar el formulario de registro
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        // Supongamos que ya has validado los datos

        $nombre = trim($_POST['nombre']);
        $apellidos = trim($_POST['apellidos']);
        $tel = trim($_POST['tel']);
        $email = trim($_POST['email']);
        $pwd = password_hash(trim($_POST['pwd']), PASSWORD_BCRYPT); 
        $_SESSION['nombre'] = $nombre;       // Guardar el nombre en la sesión
        $_SESSION['apellidos'] = $apellidos; // Guardar los apellidos en la sesión
        $_SESSION['tel'] = $tel;             // Opcionalmente guardar el teléfono

        // Redirigir al dashboard o página de éxito
        header('Location: dashboard.php'); 
        exit(); // Asegúrate de terminar el script después de redirigir
    }
    ?>

    <div class="register">

            <form  id="registerForm" class="form-register" method="POST">
                <div class="form-group">
                    <label for="nombre">Nombre</label>
                    <input type="text" id="nombre" name="nombre" placeholder="Nombre">
                </div>

                <div class="form-group">
                    <label for="apellidos">Apellidos</label>
                    <input type="text" id="apellidos" name="apellidos" placeholder="Apellidos">
                </div>

                <div class="form-group">
                    <label for="tel">Telefono</label>
                    <input type="text" id="tel" name="tel" placeholder="Telefono">
                    <span id="error-tel" style="color:red; display:none;">Los teléfonos no coinciden</span>
                </div>

                <div class="form-group">
                    <label for="tel_confir">Confirmar Telefono</label>
                    <input type="text" id="tel_confir" name="tel_confir" placeholder="Confirmar Telefono">
                </div>


                <div class="form-group">
                    <label for="email">Correo Electrónico</label>
                    <input type="text" id="email" name="email" placeholder="Correo Electrónico">
                    <span id="error-email" style="color:red; display:none;">Los correos electrónicos no coinciden</span>
                    <!--<span id="error-email" style="color:red; display:none;">Formato de correo inválido</span>-->
                </div>
                <div class="form-group">
                    <label for="email_confir">Corfirmar Correo Electrónico </label>
                    <input type="text" id="email_confir" name="email_confirm" placeholder="Confirma Correo Electrónico">
                    <span id="error-email" style="color:red; display:none;">Los correos electrónicos no coinciden</span>
                    <span id="error-email" style="color:red; display:none;">Formato de correo inválido</span>
                </div>

                <div class="form-group">
                    <label for="pwd">Contraseña</label>
                    <input type="password" id="pwd" name="pwd" placeholder="Contraseña" >
                    <span id="error-pwd" style="color:red; display:none;">Las contraseñas no coinciden</span>
                </div>

                <div class="form-group">
                    <label for="pwd_confir">Confirmar Contraseña </label>
                    <input type="password" id="pwd_confir" name="pwd_confir" placeholder="Confirmar Contraseña">
                </div>

                <div class="form-group">
                    <button type="submit" class="submit-btn">Registrarme</button>                    
                </div>
                <div id="loader">
                    <img src="img/loading-7528_128.gif" alt="cargando...">
                </div>
            </form>
            
    </div>
    <!-- <script src="app.js?v=1.2"></script>-->
    <script src="js/functions.js?ts=<?= time(); ?>"> </script>
</body>
</html>