<?php
error_reporting(E_ALL); 
ini_set('display_errors','1');
session_start();

//set_time_limit(150);

header ("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); //ultima actualizacion ahora cuando la cargamos
header ("Cache-Control: no-cache, must-revalidate"); //no guardar en CACHE
header ("Expires: Thu, 27 Mar 1980 23:59:00 GMT"); //la pagina expira en una fecha pasada
header ("Pragma: no-cache"); 
header('Content-type: application/json');

require_once 'libs/PHPmailer/src/Exception.php';
require_once 'libs/PHPmailer/src/PHPMailer.php';
require_once 'libs/PHPmailer/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

//Variables globales 


$type = isset($_POST['type']) ? $_POST['type'] : null;

if ($type == 1) { // Acción de login    
    $message = "ok";
    $errorflag = 0;
    $ObjResult = "";

    $username = trim($_POST['username']);
    $password = trim($_POST['password']);    
    $localStorageUsers = $_POST['localStorageUsers'];
    $verificado = trim($_POST['estatus']);


    $usuarioEncotrado = false;
    
    // Validaciones para login
    if ($username == "") {
        $message = "Error [1:1] Ingresa un usuario";
        $errorflag = 1;
        $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
        $data = json_encode(value: $res);
        echo $data;
        exit();
    }
    if ($password == "") {
        $message = "Error [1:2] Ingresa una contraseña";
        $errorflag = 1;
        $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
        $data = json_encode(value: $res);
        echo $data;
        exit();
    }
    
    // Verificar si el usuario existe en los datos del localStorage
    foreach ($localStorageUsers as $user) {

        if ($user['email'] === $username && $user['pwd'] === $password) {
            $usuarioEncotrado = true;
            break;
        }
    }

    if(!$usuarioEncotrado){
        $message = "Error [1:3] Usuario o Contraseña Invalido";
        $errorflag = 1;

        $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
        echo json_encode($res);
        exit();

    }

    if ($verificado == 0) {
        $message = "Error [1:4] Usuario por confirmar por favor revisa tu buzon de email para activar tu cuenta";
        $errorflag = 1;
        $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
        $data = json_encode(value: $res);
        echo $data;
        exit();
    }

    // Si el usuario es válido, iniciar la sesión
    //session_start();
    $_SESSION['username'] = $username; // Guardar el usuario en la sesión
    $_SESSION['SystemName'] = 'loginIdeeo'; // Guardar nombre del sistema en la sesión

    // Enviar respuesta exitosa
    $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
    echo json_encode($res);
    exit();   
   
}

if ($type == 2) { // Acción de Cerrar Sesión
    $errorflag = 0; // Inicializamos la variable
    $ObjResult = ""; // Inicializamos la variable
    
    session_unset(); // Limpiar todas las variables de sesión
    session_destroy(); // Destruir la sesión
    $message = "Has cerrado sesión correctamente."; // Mensaje de éxito
    $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
    $data = json_encode($res);
    echo $data;
    exit();
}

if ($type == 3) { // Acción de Registro    

    $message = "ok";
    $errorflag = 0;
    $ObjResult = "";

    //Obteniendo datos del formulario
    $nombre = trim($_POST['nombre']);
    $apellidos = trim($_POST['apellidos']);
    $tel = trim($_POST['tel']);
    $tel_confir = trim($_POST['tel_confir']);
    $email = trim($_POST['email']);
    $email_confir = trim($_POST['email_confir']);
    $pwd = trim($_POST['pwd']);
    $pwd_confir = trim($_POST['pwd_confir']);

    //$localStorageUsers = $_POST['localStorageUsers2'];//users de localstorage       
    /**Validaciones de campos vacíos*
     * ******************************/

    if (empty($nombre)) {
        $message = "Error [3:1] Ingresa tu nombre.";
        $errorflag = 1;

        $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
        $data = json_encode(value: $res);
        echo $data;
        exit();
    } 
    if (empty($apellidos)) {
        $message = "Error [3:2] Ingresa tus apellidos.";
        $errorflag = 1;

        $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
        $data = json_encode(value: $res);
        echo $data;
        exit();
    } 
    if (empty($tel)) {
        $message = "Error [3:3] Ingresa tu teléfono.";
        $errorflag = 1;

        $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
        $data = json_encode(value: $res);
        echo $data;
        exit();
    }
     
    if ($tel !== $tel_confir) {
        $message = "Error [3:4] Los teléfonos no coinciden.";
        $errorflag = 1;

        $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
        $data = json_encode(value: $res);
        echo $data;
        exit();
    } 
    
    if (empty($email)) {
        $message = "Error [3:5] Ingresa tu correo electrónico.";
        $errorflag = 1;

        $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
        $data = json_encode(value: $res);
        echo $data;
        exit();
    } 
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = "Error [3:6] El formato del correo electrónico es inválido.";
        $errorflag = 1;

        $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
        $data = json_encode(value: $res);
        echo $data;
        exit();
    } 
    
    if ($email !== $email_confir) {
        $message = "Error [3:7] Los correos electrónicos no coinciden.";
        $errorflag = 1;

        $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
        $data = json_encode(value: $res);
        echo $data;
        exit();
    } 
    if (empty($pwd)) {
        $message = "Error [3:8] Ingresa una contraseña.";
        $errorflag = 1;

        $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
        $data = json_encode(value: $res);
        echo $data;
        exit();
    } 
    
    if ($pwd !== $pwd_confir) {
        $message = "Error [3:9] Las contraseñas no coinciden.";
        $errorflag = 1;

        $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
        $data = json_encode(value: $res);
        echo $data;
        exit();
    }
    
    // Si no hay errores, simular guardado del usuario    
  
    if ($errorflag == 0) {

        $message = "Registro exitoso. Bienvenido, $nombre!";        

    }
    // Respuesta en formato JSON    
    $res = (object) array('flagerror' => $errorflag, 'Message' => $message, 'ObjResult' => $ObjResult);
    $data = json_encode(value: $res);
    echo $data;
    exit();
    
}

if($type == 4){

    $message="ok";
    $errorflag = 0;

    $nombre = trim($_POST['nombre']);
    $email = trim($_POST['email']);
    $token = trim($_POST['token']);

    $nombre = isset($_POST['nombre']) ? trim($_POST['nombre']):'';
    $email = isset($_POST['email']) ? trim($_POST['email']): '';
    $token = isset($_POST['token']) ? trim($_POST['token']): '';

    if (empty($email)) {
        $message = "Error[4:1] Falta el correo";
        $errorflag=1;
    }
    if (empty($token)) {
        $message = "Error[4:2] Falta el token";
        $errorflag = 1;
    }
    else{
        //$enlaceVerificacion = "http://localhost/loginideeov2/activar.php?token=$token";
        //http://loginideeov2.test/activar.php

        $enlaceVerificacion = "http://loginideeov2.test/activar.php?token=$token";
        $mail = new PHPMailer(true);
    
        try {
            // Configure PHPMailer
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'toledotoledomax@gmail.com';
            $mail->Password = 'vpzx vrbi rdsm ziot';
            $mail->SMTPSecure = 'ssl';
            $mail->Port = 465;

            // Configure Email
            $mail->setFrom('no-reply@dominio.com', 'DevMax');
            $mail->addAddress($email,$nombre);
    
            //Contenido del correo
            $mail->isHTML(true);
            $mail->Subject = 'Verifica tu cuenta';
            $mail->Body = "Hola $nombre, <br><br>Gracias por registrarte. Por favor verifica tu cuenta haciendo clic en el siguiente enlace: <a href='$enlaceVerificacion'>Verificar mi cuenta</a>";
    
            $mail->send();
                //echo json_encode(['flagerror' => 0, 'Message' => 'Correo de verificación enviado.']);
    
        } catch (Exception $e) {
            $errorflag = 1;
            $message = "Error al enviar el correo: " . $mail->ErrorInfo;
                //echo json_encode(['flagerror' => 1, 'Message' => 'No se pudo enviar el correo.']);
        }
   }

   $res = (object) array('flagerror' => $errorflag, 'Message' => $message);
    echo json_encode($res);
    exit();
}

if ($type ==5) {
    
    $message = "ok";
    $errorflag = 0;
    $ObjResult = "";
    
    $token =isset($_POST['token']) ? trim(($_POST['token'])) : '';

    if (empty($token)) {
        
        $message= "Error[5:1] Falta el token de activación";
        $errorflag = 1;
    }

    if ($errorflag == 0) {
         // Actualizar el estado del usuario en la base de datos
        $message = "Activación exitoso";
    }

    // Respuesta JSON que se envía al frontend
    $res = (object) array('flagerror' => $errorflag, 'Message' => $message);
    echo json_encode($res);
    exit();

}
