$(document).ready(function () {
    jQuery(document).on('click', '#btnLogin', function (event) {
      $("#btnLogin").prop("disabled", true);
      var error = 0;
      if ($("#userLogin").val() == 0 && error == 0) {
        alertForm('userLogin', 'Ingrese su nombre de usuario');
        error = 1;
      }
      if ($("#passLogin").val() == 0 && error == 0) {
        alertForm('passLogin', 'Escribe un comentario general');
        error = 1;
      }
      if (error == 0) {
        var datos = new FormData($("#formLogin")[0]);
        $.ajax({
          url: "../src/class/stg.php",
          type: 'POST',
          dataType: 'JSON',
          cache: false,
          contentType: false,
          processData: false,
          data: datos,
          beforeSend: function (objeto) {
            $(".loader").show();
          },
          success: function (response) {
            $("#btnLogin").prop("disabled", false);
            $(".loader").hide();
            if (response.flagError == 1) {
              alertError(response.message, '');
            } else if (response.flagError == 0) {
              //alertOk("Muy bien!", response.message, "location = dash.php");
              if (response.flagDashboard == 0) {
                setTimeout('window.location.href = "dash.php"',1000);
              }
              else{
                setTimeout('window.location.href = "../dashboard/index.php"',1000);
              }
            }
          }
        });
      }
      else{
        $("#btnLogin").prop("disabled", false);
      }
    });
    
    jQuery(document).on('click', '#btnSendDataTurno', function (event) {
      //$("#btnSendDataTurno").prop("disabled", true);
      var error = 0;
      var totMotivosCheck = 0
      $('input[name="motivos[]"]').each(function () {
        if (this.checked) {
        totMotivosCheck+=1;
        }
      });
      if ($("#numeroEmpleado").val() == 0 && error == 0) {
        alertForm('numeroEmpleado', 'Escribe un numero de empleado');
        error = 1;
      }
      if (totMotivosCheck == 0 && error == 0) {
        alertForm('motivos', 'Selecciona al menos un motivo');
        error = 1;
      }
      if ($("#comentarioGeneral").val() == 0 && error == 0) {
        alertForm('comentarioGeneral', 'Escribe un comentario general');
        error = 1;
      }
      if (error == 0) {
        alertConfirm('Confirma!','Â¿Estas seguro de guardar los cambios?','sendDataTurno();')
      }
      /*else{
        $("#btnSendDataTurno").prop("disabled", false);
      }*/
    });

    //genera nuevo turno
    jQuery(document).on('click', '#btnSendDataNewTurn', function (event) {
      $("#btnSendDataNewTurn").prop("disabled", true);
      var error = 0;
      if ($('input[name=motivoVisit]:checked', '#dataNewTurn').val() == null && error == 0) {
        alertForm('motivoVisit', 'Selecciona un motivo');
        error = 1;
      }
      if (error == 0) {
        var datos = new FormData($("#dataNewTurn")[0]);
        $.ajax({
          url: "../src/class/stg.php",
          type: 'POST',
          dataType: 'JSON',
          cache: false,
          contentType: false,
          processData: false,
          data: datos,
          beforeSend: function (objeto) {
            $(".loader").show();
          },
          success: function (response) {
            $("#btnSendDataNewTurn").prop("disabled", false);
            $(".loader").hide();
            if (response.flagError == 1) {
              alertError(response.message, '');
              setTimeout('location=index.php',1000);
            } else if (response.flagError == 0) {
              //alertOk("Muy bien!", response.message, "");
              alertConfirmTurno('Â¡Muy bien!',response.message,response.keyTurno);
              $("#createNewTurn").modal('hide');
              $('#frameTurnos',window.parent.document).attr('src',$('#frameTurnos',window.parent.document).attr('src'));
            }
          }
        });
      }
      else{
        $("#btnSendDataNewTurn").prop("disabled", false);
      }
    });
  });
  

  function sendDataTurno(){
    $("#btnSendDataTurno").prop("disabled", true);
    var datos = new FormData($("#formDetalleTurno")[0]);
        $.ajax({
          url: "../src/class/stg.php",
          type: 'POST',
          dataType: 'JSON',
          cache: false,
          contentType: false,
          processData: false,
          data: datos,
          beforeSend: function (objeto) {
            $(".loader").show();
          },
          success: function (response) {
            $("#btnSendDataTurno").prop("disabled", false);
            $(".loader").hide();
            if (response.flagError == 1) {
              alertError(response.message, '');
            } else if (response.flagError == 0) {
              $("#flagOpenTurn").val(0);
              //alertOk("Muy bien!", response.message, "location.reload();");
              location.reload();
            }
          }
        });
  }


  // -----------------------------> FUNCIONES SWEET ALERT <-------------------------------------
  function alertConfirmTurno(title, message, key) {
    Swal.fire({
      title: title,
      html: message,
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Atender ahora',
      cancelButtonText: 'Formar turno',
      reverseButtons: true
    }).then((result) => {
      if (result.value) {
        var error = 0;
        if($("#flagOpenTurn").val() == 1){
          error = 1;
          alertError('No puedes atender un turno, si tienes otro abierto, el turno se agrego a la fila', '');
        }
        if(error == 0){
          attendTurn(key);
        }
      }
    })
  }

  function alertConfirm(title, message, action) {
    Swal.fire({
      title: title,
      text: message,
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Continuar',
      cancelButtonText: 'Cancelar',
      reverseButtons: true
    }).then((result) => {
      if (result.value) {
        eval(action);
      }
    })
  }
  function alertOk(title, message, action) {
    Swal.fire({
      title: title,
      html: message,
      type: 'success',
      reverseButtons: true
    }).then((result) => {
      if (result.value) {
        eval(action);
      }
    })
  }
  function alertForm(id, message) {
    Swal.fire({
      type: 'error',
      title: 'Datos incompletos',
      text: message,
      confirmButtonColor: 'red',
      confirmButtonText: 'ACEPTAR',
      //footer: '<a href>Why do I have this issue?</a>',
      reverseButtons: true
    }).then((result) => {
      if (result.value) {
        setTimeout("$('#" + id + "').focus()", 1000);
      }
    })
  }
  function alertError(message, action) {
    Swal.fire({
      type: 'error',
      title: 'Error',
      confirmButtonColor: 'red',
      confirmButtonText: 'ACEPTAR',
      html: message,
      //footer: '<a href>Why do I have this issue?</a>',
      reverseButtons: true
    }).then((result) => {
      if (result.value) {
        eval(action);
      }
    })
  }